/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.license;

import com.gamedash.daemon.common.license.domain.LicenseDomainNotFoundException;
import com.gamedash.daemon.common.license.system.LicenseSystemMaxExceededException;
import com.gamedash.daemon.license.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseValidation {
    private static Logger logger = LoggerFactory.getLogger(License.class);
    private static boolean periodicChecksHasInitialized = false;

    public static void initPeriodicChecks() throws Exception {
        if (periodicChecksHasInitialized) {
            throw new Exception("Periodic checks have already been initialized");
        }
        periodicChecksHasInitialized = true;
        new Thread(() -> {
            int failedAttempts = 0;
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(600000L);
                        License.validate();
                    }
                }
                catch (LicenseDomainNotFoundException | LicenseSystemMaxExceededException e) {
                    logger.error(e.getMessage());
                    System.exit(1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (failedAttempts >= 144) {
                        System.exit(1);
                    }
                    ++failedAttempts;
                    continue;
                }
                break;
            }
        }).start();
    }
}

