/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.QueryResponse;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHost;
import com.gamedash.daemon.fileSystem.remote.host.implementation.sftp.SFTPHostImplementation;
import com.google.gson.JsonElement;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteFileSystemHosts {
    private static Map<String, Class<?>> implementations = new HashMap<String, Class<?>>(){
        {
            this.put("SFTP", SFTPHostImplementation.class);
        }
    };
    private static List<RemoteFileSystemHost> hosts;

    public static void start() throws Exception {
        for (RemoteFileSystemHost host : RemoteFileSystemHosts.getAll()) {
            if (host.isRunning()) continue;
            host.start();
        }
    }

    public static void stop() throws Exception {
        for (RemoteFileSystemHost host : RemoteFileSystemHosts.getAll()) {
            if (!host.isRunning()) continue;
            host.stop();
        }
    }

    public static List<RemoteFileSystemHost> getAll() throws Exception {
        if (hosts == null) {
            ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/remote/host/all");
            QueryResponse queryResponse = query.get();
            ArrayList<RemoteFileSystemHost> hosts = new ArrayList<RemoteFileSystemHost>();
            for (JsonElement element : queryResponse.getJsonObject().get("response").getAsJsonArray()) {
                String implementationName = element.getAsJsonObject().get("implementation").getAsJsonObject().get("name").getAsString();
                Class<?> implementationClass = null;
                if (implementationName.equalsIgnoreCase("SFTP")) {
                    implementationClass = implementations.get("SFTP");
                }
                if (implementationClass == null) continue;
                hosts.add(new RemoteFileSystemHost(implementationClass, InetAddress.getByName(element.getAsJsonObject().get("ip").getAsString()), element.getAsJsonObject().get("port").getAsInt(), element.getAsJsonObject().get("isSecure").getAsBoolean()));
            }
            RemoteFileSystemHosts.hosts = hosts;
        }
        return hosts;
    }
}

