/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.group.ZipFileParameter;
import com.gamedash.daemon.fileSystem.file.File;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import spark.Request;
import spark.Response;

public class Zip
extends Route<String> {
    public Zip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        Gson gson = new Gson();
        List groupFiles = (List)gson.fromJson(this.getParameters().get("files").getValue(), new TypeToken<List<ZipFileParameter>>(){}.getType());
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (destination.exists() && !destination.isFile()) {
            throw new FileNotFoundException("Destination file exists, but is a directory");
        }
        if (destination.exists()) {
            destination.delete();
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(destination));){
            zipOutputStream.setLevel(1);
            for (ZipFileParameter groupFile : groupFiles) {
                File file = File.fromBase64(groupFile.path);
                if (!file.exists()) {
                    throw new IOException("File " + file.getAbsolutePath() + " does not exist");
                }
                if (file.isDirectory()) {
                    this.compressDirectory(file, groupFile.name != null ? groupFile.name : groupFile.path, zipOutputStream);
                    continue;
                }
                this.compressFile(file, groupFile.name != null ? groupFile.name : file.getName(), zipOutputStream);
            }
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "destination"};
    }

    private void compressFile(File file, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        zipOutputStream.putNextEntry(entry);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
        }
    }

    private void compressDirectory(File directory, String entryName, ZipOutputStream zipOutputStream) throws IOException {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.compressDirectory(File.fromNative(file), entryName + File.separator + file.getName(), zipOutputStream);
                continue;
            }
            this.compressFile(File.fromNative(file), entryName + File.separator + file.getName(), zipOutputStream);
        }
    }

    private static String getEntryName(File destination, File file) {
        return destination.toURI().relativize(file.toURI()).getPath();
    }
}

