/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.File;
import java.io.FileNotFoundException;
import org.apache.commons.io.FileUtils;
import spark.Request;
import spark.Response;

public class Move
extends Route<String> {
    public Move(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = File.fromBase64(this.getParameters().get("origin").getValue());
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isDirectory()) {
            throw new FileNotFoundException("Origin does not exist");
        }
        if (destination.exists()) {
            destination.delete();
        }
        FileUtils.moveDirectory(origin, destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

