/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route;

import com.gamedash.daemon.api.server.parameter.ParameterException;
import com.gamedash.daemon.api.server.parameter.Parameters;
import com.gamedash.daemon.common.utilities.QueryString;
import spark.Request;
import spark.Response;

public abstract class Route<T> {
    protected Request request;
    protected Response response;
    private Parameters parameters;

    protected Route(Request request, Response response) {
        this.request = request;
        this.response = response;
        this.parameters = new Parameters();
        QueryString.decode(request.body()).forEach((name, value) -> this.parameters.create((String)name, (String)value));
        request.params().forEach((name, value) -> this.parameters.create(name.substring(1), (String)value));
        request.queryParams().forEach(name -> {
            String value = request.queryParams((String)name);
            this.parameters.create((String)name, value);
        });
    }

    protected abstract T execute() throws Exception;

    protected String[] getRequiredParameters() {
        return new String[0];
    }

    protected final Parameters getParameters() {
        return this.parameters;
    }

    public Boolean satisfiesRequiredParameters() throws ParameterException {
        for (String name : this.getRequiredParameters()) {
            if (this.getParameters().get(name) != null) continue;
            throw new ParameterException("Parameter \"" + name + "\" is required");
        }
        return true;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }
}

