/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server;

import com.gamedash.daemon.api.server.ErrorBody;
import com.gamedash.daemon.api.server.ExceptionHandler;
import com.gamedash.daemon.api.server.authentication.NotAuthenticatedException;
import com.gamedash.daemon.api.server.route.Routes;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.fileSystem.file.FileAlreadyExistsException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderSessionNotFoundException;
import com.gamedash.daemon.network.port.PortDoesNotExistException;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.system.user.SystemUserNotFoundException;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Service;

public class ApiServer {
    private static Gson gson = new Gson();
    private static Boolean isRunning = false;
    private static Logger logger = LoggerFactory.getLogger(ApiServer.class);
    private static Service service;

    public static void start() {
        if (ApiServer.isRunning().booleanValue()) {
            return;
        }
        ApiServer.setIsRunning(true);
        try {
            service = Service.ignite();
            ApiServer.getService().ipAddress(Network.getIp().getHostAddress());
            ApiServer.getService().port(ApiServer.getPort());
            if (KeyStore.hasFile().booleanValue() && KeyStore.hasPassword()) {
                ApiServer.getService().secure(KeyStore.getFile().getAbsolutePath(), KeyStore.getPassword(), null, null);
                logger.info("TLS enabled");
            }
            new ExceptionHandler<Exception>(Exception.class).register();
            new ExceptionHandler<NotAuthenticatedException>(NotAuthenticatedException.class, 403).register();
            new ExceptionHandler<FileNotFoundException>(FileNotFoundException.class, 404).register();
            new ExceptionHandler<ProcessNotFoundException>(ProcessNotFoundException.class, 404).register();
            new ExceptionHandler<ChildProcessNotFoundException>(ChildProcessNotFoundException.class, 404).register();
            new ExceptionHandler<PortDoesNotExistException>(PortDoesNotExistException.class, 404).register();
            new ExceptionHandler<ChildProcessNotRunningException>(ChildProcessNotRunningException.class, 409).register();
            new ExceptionHandler<FileAlreadyExistsException>(FileAlreadyExistsException.class, 409).register();
            new ExceptionHandler<FileDownloaderSessionNotFoundException>(FileDownloaderSessionNotFoundException.class, 404).register();
            new ExceptionHandler<SystemUserNotFoundException>(SystemUserNotFoundException.class, 404).register();
            ApiServer.getService().before((request, response) -> {
                System.out.println(request.ip() + " " + request.requestMethod() + " " + request.uri());
                if (DevelopmentMode.isEnabled()) {
                    logger.debug("Incoming request from " + request.ip() + " for " + request.requestMethod() + " " + request.uri(), (Object)"api.server");
                }
            });
            ApiServer.getService().afterAfter((request, response) -> response.header("Server", "GameDash Daemon"));
            ApiServer.getService().notFound((request, response) -> {
                response.type("application/json");
                return gson.toJson(new ErrorBody("Invalid route"));
            });
            Routes.register();
            ApiServer.getService().awaitInitialization();
            logger.info("Listening on port " + ApiServer.getPort());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            ApiServer.setIsRunning(false);
        }
    }

    public static void stop() {
        if (ApiServer.isRunning().booleanValue()) {
            ApiServer.getService().stop();
            ApiServer.getService().awaitStop();
        }
    }

    public static Boolean isRunning() {
        return isRunning;
    }

    public static void setIsRunning(Boolean isRunning) {
        ApiServer.isRunning = isRunning;
    }

    public static Service getService() {
        return service;
    }

    public static int getPort() throws IOException, ConfigException {
        if (!Config.getFile("daemon.properties").valueExists("api.server.port")) {
            return 2147;
        }
        return Config.getFile("daemon.properties").getValue("api.server.port", Integer.class);
    }

    public static void setPort(int port) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("api.server.port", port);
    }
}

