/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.usage;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.usage.Result;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Usage {
    private static Logger logger = LoggerFactory.getLogger(Usage.class);
    private ChildProcess process;

    public Usage(ChildProcess process) {
        this.process = process;
    }

    public Result query() throws Exception {
        if (!Usage.isInstalled()) {
            throw new Exception("Not installed");
        }
        Process process = new ProcessBuilder(Usage.getFile().getAbsolutePath(), "pid=" + this.process.getId()).start();
        process.waitFor();
        if (process.exitValue() != 0) {
            throw new IOException("Query failed");
        }
        String result = IOUtils.toString(process.getInputStream(), Charset.defaultCharset());
        String[] resultBits = result.split(",");
        return new Result(Integer.valueOf(resultBits[0].replaceAll("[^0-9.]", "")), Integer.valueOf(resultBits[1].replaceAll("[^0-9.]", "")));
    }

    public static boolean isAvailable() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static void install() throws Exception {
        if (!Usage.isAvailable()) {
            throw new Exception("Not available");
        }
        if (Usage.isInstalled()) {
            throw new Exception("Already installed");
        }
        File file = Usage.getFile();
        URL url = new URL("https://assets.gamedash.io/build/daemon/process/usage/linux-x64");
        logger.info("Installing childProcess usage library");
        FileUtils.copyURLToFile(url, file);
        file.setExecutable(true);
    }

    public static void uninstall() throws Exception {
        if (!Usage.isInstalled()) {
            throw new Exception("Not yet installed");
        }
        Usage.getFile().delete();
    }

    public static boolean isInstalled() {
        File file = Usage.getFile();
        return file.exists() && file.isFile();
    }

    private static File getFile() {
        return new File("lib/childProcess/usage/linux");
    }
}

