/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.terminal.io;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.io.Io;
import com.gamedash.daemon.process.childprocess.terminal.io.OutputItem;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputHandler {
    private static Logger logger = LoggerFactory.getLogger(com.gamedash.daemon.process.childprocess.terminal.pty.Io.class);
    private Gson gson = new Gson();
    private int historySize = Io.getHistorySize();
    protected ChildProcess childProcess;
    protected BlockingQueue<OutputItem> outputItems = new ArrayBlockingQueue<OutputItem>(this.historySize);

    public OutputHandler(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
    }

    public synchronized void addOutputItem(OutputItem outputItem) {
        logger.debug(this.gson.toJson(outputItem));
        if (this.outputItems.size() >= this.historySize) {
            this.outputItems.poll();
        }
        this.outputItems.add(outputItem);
    }

    public List<OutputItem> getOutputItems() {
        return new ArrayList<OutputItem>(this.outputItems);
    }

    public List<OutputItem> getOutputItems(int tail) {
        ArrayList<OutputItem> output = new ArrayList<OutputItem>(this.outputItems);
        return output.subList(Math.max(output.size() - tail, 0), output.size());
    }
}

