/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.reference;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.reference.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class References {
    private ChildProcess childProcess;
    private static List<Reference> references = Collections.synchronizedList(new ArrayList());

    public References(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public static List<Reference> getAll() {
        return references;
    }

    public static boolean exists(String name) {
        for (Reference reference : References.getAll()) {
            if (!reference.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getAllLocal() throws Exception {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Reference reference : References.getAll()) {
            if (reference.getChildProcess().getId() != this.childProcess.getId()) continue;
            references.add(reference);
        }
        return references;
    }

    public void removeAllLocal() throws Exception {
        for (Reference reference : this.getAllLocal()) {
            References.getAll().remove(reference);
        }
    }

    public boolean has() throws Exception {
        return this.getAllLocal().size() > 0;
    }

    public Reference create(String name) throws Exception {
        if (References.exists(name)) {
            throw new Exception(String.format("Reference %s already exists", name));
        }
        Reference reference = new Reference(this.childProcess, name);
        references.add(reference);
        return reference;
    }
}

