/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.upload.session.chunk;

import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;

public class Chunks {
    private Session session;
    private List<Chunk> chunks = new CopyOnWriteArrayList<Chunk>();

    public Chunks(Session session) {
        this.session = session;
    }

    public List<Chunk> getAll() {
        return this.chunks;
    }

    public Chunk create(long id) throws Exception {
        Chunk chunk = new Chunk(this.session, id);
        this.getAll().add(chunk);
        return chunk;
    }

    public Chunk get(long id) throws Exception {
        if (!this.exists(id)) {
            throw new Exception("Chunk does not exist");
        }
        for (Chunk chunk : this.getAll()) {
            if (chunk.getId() != id) continue;
            return chunk;
        }
        throw new Exception("Could not get chunk");
    }

    public boolean exists(long id) {
        for (Chunk chunk : this.getAll()) {
            if (chunk.getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean receiveIsComplete() {
        return (long)this.getAll().size() == this.session.getChunkCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() throws Exception {
        if (!this.receiveIsComplete()) {
            throw new Exception("Did not receive all chunks yet");
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(this.session.getDestination()));
            List<Chunk> sortedChunks = this.getAll();
            sortedChunks.sort(new Comparator<Chunk>(){

                @Override
                public int compare(Chunk a, Chunk b) {
                    return b.getId() > a.getId() ? -1 : 1;
                }
            });
            for (Chunk chunk : sortedChunks) {
                try (BufferedInputStream inputStream = chunk.getStream();){
                    IOUtils.copy((InputStream)inputStream, outputStream);
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            this.session.delete();
        }
    }

    public void cleanup() {
        for (Chunk chunk : this.getAll()) {
            chunk.cleanup();
        }
    }
}

