/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.upload.session.chunk;

import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.fileSystem.FileSystem;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Chunk {
    private static Logger logger = LoggerFactory.getLogger(Chunk.class);
    private Session session;
    private long id;
    private File file;

    public Chunk(Session session, long id) throws Exception {
        this.session = session;
        this.id = id;
        this.file = this.getFile();
    }

    public long getId() {
        return this.id;
    }

    public boolean hasContents() {
        return this.file.exists();
    }

    public void write(InputStream inputStream) throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        logger.debug("Writing chunk to " + this.file.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
        }
    }

    public BufferedInputStream getStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public boolean isLast() {
        return this.getId() == (long)(this.session.getChunks().getAll().size() - 1);
    }

    public void cleanup() {
        this.file.delete();
    }

    private File getFile() throws IOException {
        return new File(Chunk.getDirectory() + File.separator + this.session.getId().toString() + "_" + this.getId());
    }

    public static File getDirectory() throws IOException, ConfigException {
        if (!Config.getFile("daemon.properties").valueExists("fileSystem.file.upload.session.chunk.directory")) {
            return FileSystem.getTmpDirectory();
        }
        return new File(Config.getFile("daemon.properties").getValue("fileSystem.file.upload.session.chunk.directory"));
    }

    public static void setDirectory(File directory) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("fileSystem.file.upload.session.chunk.directory", directory.getPath());
    }
}

