/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import java.io.IOException;
import spark.Request;
import spark.Response;

public class CreateSession
extends Route<String> {
    public CreateSession(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        int chunkCount = this.getParameters().get("chunkCount").getValue(Integer.class);
        if (destination.exists() && destination.isDirectory()) {
            throw new IOException("Destination path already exists, however it is a directory");
        }
        Session session = Sessions.create(destination, chunkCount);
        return session.getId().toString();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "chunkCount"};
    }
}

