/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory;

import com.gamedash.daemon.api.server.route.Route;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import spark.Request;
import spark.Response;

public class GetSize
extends Route<Long> {
    public GetSize(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Long execute() throws Exception {
        com.gamedash.daemon.fileSystem.File directory = com.gamedash.daemon.fileSystem.File.fromBase64(this.getParameters().get("path").getValue());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IOException("Directory does not exist");
        }
        long totalSize = 0L;
        List files = (List)FileUtils.listFilesAndDirs(directory, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
        for (File file : files) {
            if (!file.isFile()) continue;
            totalSize += file.length();
        }
        return totalSize;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

