/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.IOException;
import org.zeroturnaround.zip.ZipUtil;
import spark.Request;
import spark.Response;

public class Unzip
extends Route<String> {
    public Unzip(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = File.fromBase64(this.getParameters().get("origin").getValue());
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new IOException("Origin file does not exist");
        }
        if (!destination.exists() || !destination.isDirectory()) {
            throw new IOException("Destination directory does not exist");
        }
        ZipUtil.unpack(origin, (java.io.File)destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

