/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.IOException;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import spark.Request;
import spark.Response;

public class Read
extends Route<String> {
    public Read(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = File.fromBase64(this.getParameters().get("path").getValue());
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File does not exist");
        }
        return Base64.getEncoder().encodeToString(FileUtils.readFileToString(file).getBytes());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

