/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import spark.Request;
import spark.Response;

public class Move
extends Route<String> {
    public Move(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = File.fromBase64(this.getParameters().get("origin").getValue());
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (!origin.exists() || !origin.isFile()) {
            throw new IOException("Origin does not exist");
        }
        if (origin.compareTo(destination) == 0) {
            throw new IOException("Can not move a file to itself");
        }
        if (destination.exists()) {
            destination.delete();
        }
        FileUtils.moveFile(origin, destination);
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin", "destination"};
    }
}

