/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.parameter.ParameterException;
import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;

public class Download
extends Route<String> {
    private static Logger logger = LoggerFactory.getLogger(Download.class);

    public Download(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = this.getDestination();
        if (destination.exists() && !destination.isFile()) {
            throw new IOException("Destination already exists, but is not a file");
        }
        if (this.isAsync()) {
            new Thread(() -> {
                try {
                    this.downloadFile();
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }).start();
        } else {
            this.downloadFile();
        }
        return null;
    }

    private void downloadFile() throws Exception {
        FileUtils.copyURLToFile(new URL(new String(Base64.getDecoder().decode(this.getParameters().get("url").getValue()))), this.getDestination());
    }

    private boolean isAsync() throws ParameterException {
        return this.getParameters().exists("async") && this.getParameters().get("async").getValue(Boolean.class) != false;
    }

    private File getDestination() throws ParameterException {
        return File.fromBase64(this.getParameters().get("destination").getValue());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "url"};
    }
}

