/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.File;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import spark.Request;
import spark.Response;

public class Append
extends Route<String> {
    public Append(Request request, Response response) {
        super(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws Exception {
        File file = File.fromBase64(this.getParameters().get("path").getValue());
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("File does not exist");
        }
        List<File> sources = this.getSources();
        for (File source : sources) {
            if (source.exists() && !source.isDirectory()) continue;
            throw new IOException("Source file " + source.getPath() + " does not exist");
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file.toNative()));){
            for (File source : sources) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source));){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        }
        return null;
    }

    private List<File> getSources() throws Exception {
        ArrayList<File> sources = new ArrayList<File>();
        for (String pathString : this.getParameters().get("sources").getList()) {
            sources.add(File.fromBase64(pathString));
        }
        return sources;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path", "sources"};
    }
}

